<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model\Dao;

use Nette\SmartObject;

class Category
{
	use SmartObject;

	public int     $id;
	public string  $lang;
	public string  $title;
	public string  $alias;
	public ?string $layout        = null;
	public ?string $password      = null;
	public int     $articlesCount = 0;
	public ?int    $rootId        = null;
	public ?string $rootName      = null;
	public ?int    $lvl           = null;
	public ?int    $parentId      = null;
	public ?string $text          = null;

	public function __construct(
		int    $id,
		string $lang,
		string $title,
		string $alias
	)
	{
		$this->id    = $id;
		$this->lang  = $lang;
		$this->title = $title;
		$this->alias = $alias;
	}

	public function getId(): int { return $this->id; }
}
