<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model;

use Blog\Model\Entities\Article;
use Blog\Model\Entities\FavouriteArticle;
use Blog\Model\Entities\FavouriteGroup;
use Core\Model\Helpers\BaseFrontEntityService;
use Exception;
use Users\Model\Entities\User;

/**
 * @method FavouriteArticle|null getReference($id)
 */
class Favourites extends BaseFrontEntityService
{
	protected $entityClass = FavouriteArticle::class;

	public function addToFavourites(int $articleId, string $group, int $userId): ?int
	{
		try {
			/** @var FavouriteGroup $group */
			$group = $this->em->getReference(FavouriteGroup::class, $group);

			/** @var Article $article */
			$article = $this->em->getReference(Article::class, $articleId);

			/** @var User $user */
			$user = $this->em->getReference(User::class, $userId);

			$entity = new FavouriteArticle($group, $article, $user);
			$this->em->persist($entity);
			$this->em->flush();

			return $entity->getId();
		} catch (Exception $e) {
		}

		return null;
	}

	public function removeFromFavourites(int $articleId, string $group, int $userId): bool
	{
		try {
			$entity = $this->getEr()->findOneBy([
				'article' => $articleId,
				'group'   => $group,
				'user'    => $userId,
			]);

			if ($entity) {
				$this->em->remove($entity);
				$this->em->flush();

				return true;
			}
		} catch (Exception $e) {
		}

		return false;
	}

	public function getByUser(int $userId): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('f')
			         ->select('IDENTITY(f.article) as article, IDENTITY(f.group) as group')
			         ->where('f.user = :user')
			         ->setParameter('user', $userId)
			         ->getQuery()->getArrayResult() as $row) {
			$arr[$row['group']][$row['article']] = $row['article'];
		}

		return $arr;
	}
}
