<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\ArticlesList;
use Blog\FrontModule\Components\IArticlesListFactory;
use Blog\Model\Authors;
use Core\Model\Entities\EntityManagerDecorator;
use Nette\Application\BadRequestException;

final class AuthorPresenter extends BasePresenter
{
	/** @var EntityManagerDecorator @inject */
	public $em;
	protected Authors $authorsService;

	public function __construct(Authors $authors)
	{
		parent::__construct();
		$this->authorsService = $authors;
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	/**
	 * @param string $alias
	 * @throws BadRequestException
	 */
	public function actionDefault($alias): void
	{
		if (!$alias || !($author = $this->authorsService->findByAlias($alias))) {
			$this->error();
		}

		$this->template->author = $author;
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentArticlesList(IArticlesListFactory $factory): ArticlesList
	{
		return $factory->create();
	}
}
