<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Blog\Model\BlogCache;
use Blog\Model\Categories;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\Http\Session;
use Nette\SmartObject;

class CategoryListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static int $i = 0;
	protected Cache $cache;
	protected Cache $navigationCache;
	protected Session $session;
	protected BlogCache $blogCache;

	public function __construct(
		Storage   $cacheStorage,
		Session   $session,
		BlogCache $blogCache
	)
	{
		$this->session         = $session;
		$this->cache           = new Cache($cacheStorage, Categories::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->blogCache       = $blogCache;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 */
	public function postHandler(Category $category, LifecycleEventArgs $event): void
	{
		foreach ($category->getTexts()->getKeys() as $l) {
			$this->cache->remove('categories/' . $l);
		}

		$this->navigationCache->clean([Cache::TAGS => ['articles']]);

		$this->blogCache->getCache()->clean([
			Cache::Tags => ['getAll', 'author', 'featured'],
		]);
	}
}
