<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="blog__article_hits")
 * @ORM\Entity
 */
class Hit
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Article")
	 * @ORM\JoinColumn(name="article_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?Article $article;

	/**
	 * @ORM\Column(type="integer", options={"unsigned"=true})
	 */
	public int $shows;

	/**
	 * @var DateTime
	 * @ORM\Column(type="date")
	 */
	public $date;

	public function __construct(?Article $article, DateTimeInterface $date = null)
	{
		$this->article = $article;
		$this->shows   = 0;
		$this->date    = $date instanceof DateTime ? $date : new DateTime;
	}
}
