<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Blog\AdminModule\Model\Categories as CategoriesAdmin;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;
use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Contributte\Translation\Translator;
use Core\Model\Sites;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;

class Articles extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'blogArticles';

	protected ArticlesService   $articlesService;
	protected CategoriesService $categoriesService;
	protected Translator        $translator;
	protected Sites             $sites;
	protected CategoriesAdmin   $categoriesAdmin;

	public function __construct(
		ArticlesService   $articles,
		CategoriesService $categories,
		Translator        $translator,
		Sites             $sites,
		CategoriesAdmin   $categoriesAdmin
	)
	{
		$this->articlesService   = $articles;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
		$this->sites             = $sites;
		$this->categoriesAdmin   = $categoriesAdmin;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (count($this->sites->getSites()) > 1) {
			$flat = [];
			foreach ($this->sites->getSites() as $site) {
				$tmp = $this->categoriesAdmin->getFlatTree($site->getIdent());

				if (empty($tmp)) {
					continue;
				}

				$flat[] = [[
					'id'     => $tmp[0]['parent'],
					'parent' => 0,
					'name'   => $site->getIdent(),
				]];

				$flat[] = $tmp;
			}
			$flat = array_merge(...$flat);

			$formContainer->addCheckboxNestedList($this->getName(), $this->getTitle(), $flat);
		} else {
			$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $this->categoriesService->getOptionsForSelect());
		}
	}

	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		$limit = $params['limit'] ?? null;

		$default = $this->getDefault();

		return $this->articlesService->getAll(is_null($default) || is_array($default) ? $default : [], null, $limit);
	}
}
