<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Contributte\Translation\Translator;
use Core\Model\Sites;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;

class Featured extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'blogFeatured';

	protected ArticlesService   $articlesService;
	protected CategoriesService $categoriesService;
	protected Translator        $translator;
	protected Sites             $sites;

	public function __construct(
		ArticlesService   $articles,
		CategoriesService $categories,
		Translator        $translator,
		Sites             $sites
	)
	{
		$this->articlesService   = $articles;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
		$this->sites             = $sites;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
	}

	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		$limit = $params['limit'] ?? 8;

		return $this->articlesService->getFeatured((int) $limit);
	}
}
