<?php declare(strict_types = 1);

namespace Blog\Model\UI\Category;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseService;
use Nette\Utils\ArrayHash;

class Renderer extends BaseService
{
	protected ?ArrayHash $layouts = null;
	protected ArrayHash  $params;
	protected Translator $translator;

	public function __construct(array $params, Translator $translator)
	{
		$this->params     = ArrayHash::from($params);
		$this->translator = $translator;
		$this->layouts    = null;
	}

	public function getLayouts(): ArrayHash
	{
		if ($this->layouts === null) {
			$tmp = [];
			foreach ($this->params->layouts as $k => $v) {
				$tmp[$k]['name'] = $this->translator->translate($v->name);
			}

			$this->layouts = ArrayHash::from($tmp);
		}

		return $this->layouts;
	}
}
