<?php declare(strict_types = 1);

namespace Blog\AdminModule\Model;

use Blog\Model\Entities\Article;
use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;

class Articles extends BaseEntityService
{
	protected $entityClass = Article::class;

	final public const CACHE_NAMESPACE = 'articles';
	protected ?array $cOptionsForSelect = null;

	public function __construct(protected Translator $translator)
	{
	}

	public function invertPublish(int $id, string $lang): bool
	{
		$article = $this->get($id);

		if (!$article || !$article->getText($lang)) {
			return false;
		}

		$article->getText($lang)->isPublished = !$article->getText($lang)->isPublished;
		$this->em->persist($article->getText($lang))->flush();

		return true;
	}

	public function removeArticle(int|string $articleId): bool
	{
		if ($article = $this->getEr()->find($articleId)) {
			$this->em->remove($article);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param int[]|string[] $ids
	 */
	public function removeArticles(array $ids): array
	{
		$errors = [];
		foreach ($ids as $id) {
			if (!$this->removeArticle($id)) {
				$errors[] = $id;
			}
		}

		return $errors;
	}

	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];

			foreach ($this->getEr()->createQueryBuilder('a')
				         ->select('a.id, at.title')
				         ->innerJoin('a.texts', 'at', Join::WITH, 'at.lang = :lang')
				         ->setParameters([
					         'lang' => $this->translator->getLocale(),
				         ])->getQuery()->getScalarResult() as $row) {
				$this->cOptionsForSelect[$row['id']] = $row['title'];
			}
		}

		return $this->cOptionsForSelect;
	}

}
