<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Category\CategoriesGrid;
use Blog\AdminModule\Components\Category\CategoryForm;
use Blog\AdminModule\Components\Category\ICategoriesGridFactory;
use Blog\AdminModule\Components\Category\ICategoryFormFactory;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Multiplier;

class CategoriesPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('blog.title.categories', 'fa fa-list');
		$this->template->sites = $this->sitesService->getAll();

		$this['navigation']->setData(['header' => [
			[
				'title' => 'blog.menu.addCategory',
				'link'  => $this->link('add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	public function handleAdd(): void
	{
		$this->template->modalTitle       = $this->t('blog.title.newCategory');
		$this->template->modal            = 'categoryForm';
		$this->template->modalDialogClass = 'modal-xl';
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentCategoryForm(ICategoryFormFactory $factory): CategoryForm
	{
		$control = $factory->create();

		$control['form']->onAnchor[] = function() use ($control) {
			$control['form']->onSuccessSave[]         = function(BaseForm $form) {
				$this['categoriesGrid-' . $form->getCustomData('siteIdent')]->redrawControl('list');
				$this->payload->hideModal = true;
				$this->redrawControl('flashes');
			};
			$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
				$this['categoriesGrid-' . $form->getCustomData('siteIdent')]->redrawControl('list');
				$this->payload->hideModal = true;
				$this->redrawControl('flashes');
			};
			$control['form']->getComponent('saveControl')->closeModalOnCancel();
		};

		return $control;
	}

	protected function createComponentCategoriesGrid(ICategoriesGridFactory $factory): Multiplier
	{
		return new Multiplier(fn(string $sideIdent): CategoriesGrid => $factory->create($sideIdent));
	}
}
