<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Article\ArticlesGrid;
use Blog\AdminModule\Components\Article\IArticlesGridFactory;

final class DefaultPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setTitle($this->translator->translate('blog.title.blog'));
		$this->setHeader('blog.title.blog', 'fa fa-list-alt');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'blog.menu.addArticle',
				'link'  => 'Articles:add',
				'ico'   => 'plus',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentArticlesGrid(IArticlesGridFactory $factory): ArticlesGrid
	{
		return $factory->create();
	}
}