<?php declare(strict_types = 1);

namespace Blog\DI;

use Core\DI\CompilerExtension;
use Nette;

class BlogExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Blog' => 'Blog\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('Blog\Model\BlogConfig::setParams(?);', [$builder->parameters['blog']]);

		$init->addBody(
			'$this->getService(\'blog.front.articles\')->linkGenerator = $this->getService(\'application.linkGenerator\');',
		);
	}
}
