<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model\Dao;

use DateTime;
use Gallery\FrontModule\Model\Dao\Album;
use Nette\SmartObject;
use Users\Model\Entities\User;

class Article
{
	use SmartObject;

	public ?int      $id          = null;
	public ?string   $lang        = null;
	public ?string   $layout      = null;
	public ?string   $title       = null;
	public ?string   $alias       = null;
	public ?string   $introtext   = null;
	public ?string   $fulltext    = null;
	public ?DateTime $created     = null;
	public ?DateTime $modified    = null;
	public ?int      $createdById = null;
	public ?Author   $createdBy   = null;
	public ?User     $modifiedBy  = null;
	public ?int      $categoryId  = null;
	public ?Category $category    = null;
	public array     $tags        = [];
	public ?int      $galleryId   = null;
	public ?Album    $gallery     = null;
	public ?int      $featured    = null;
	public array     $params      = [];
	public ?DateTime $publishUp   = null;
	public ?DateTime $publishDown = null;
	public ?string   $link        = null;
	public ?array    $seo         = null;
	public ?string   $video       = null;

	/**
	 * @param string $key
	 *
	 * @return mixed
	 */
	public function getParam($key) { return $this->params[$key] ?? null; }

	public function getId(): int { return $this->id; }

	public function getGallery(): ?Album { return $this->gallery; }

	public function getSeo(): ?array { return $this->seo; }

	public function getModified(): ?DateTime { return $this->modified; }

	public function getAuthor(): ?Author { return $this->createdBy; }
}
