<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model\Dao;

class Author
{
	protected array $data = [];

	public function __construct(protected int $id, protected string $firstName, protected string $lastName)
	{
	}

	public function getId(): int { return $this->id; }

	public function getFirstName(): string { return $this->firstName; }

	public function getLastName(): string { return $this->lastName; }

	public function getName(): string { return trim($this->getFirstName() . ' ' . $this->getLastName()); }

	public function setData(array $data): void
	{
		$this->data = $data;
	}

	/**
	 * @return array|mixed|null
	 */
	public function getData(?string $key = null) { return $key ? ($this->data[$key] ?? null) : $this->data; }
}
