<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Model\Favourites;
use Blog\Model\Articles;
use Blog\Model\BlogConfig;
use Nette\DI\Attributes\Inject;

abstract class BasePresenter extends \Core\FrontModule\Presenters\BasePresenter
{
	#[Inject]
	public Favourites $favourites;

	#[Inject]
	public Articles $articlesService;

	#[Inject]
	public \Blog\FrontModule\Model\Articles $articlesDaoService;

	public function beforeRender(): void
	{
		parent::beforeRender();

		if (BlogConfig::load('allowFavourite') && $this->getUser()->isLoggedIn()) {
			$res               = [];
			$favouritesByGroup = $this->favourites->getByUser($this->getUser()->getId());
			$ids               = [];
			foreach ($favouritesByGroup as $k => $v) {
				$ids = [...$ids, ...array_keys($v)];
			}
			$ids = $this->articlesDaoService->getArticles(array_unique($ids));

			foreach ($favouritesByGroup as $k => $v) {
				foreach ($v as $v2) {
					$res[$k][$v2] = $ids[$v2];
				}
			}

			$this->template->favourites = $res;
		}
	}
}
