<?php declare(strict_types = 1);

namespace Blog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010108 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE blog__article (id INT AUTO_INCREMENT NOT NULL, category_id INT DEFAULT NULL, gallery_id INT DEFAULT NULL, created_by INT DEFAULT NULL, modified_by INT DEFAULT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, is_published SMALLINT NOT NULL, introtext VARCHAR(255) DEFAULT NULL, `text` LONGTEXT DEFAULT NULL, image VARCHAR(255) DEFAULT NULL, video VARCHAR(255) DEFAULT NULL, created DATETIME NOT NULL, modified DATETIME DEFAULT NULL, publish_up DATETIME DEFAULT NULL, publish_down DATETIME DEFAULT NULL, featured VARCHAR(60) DEFAULT NULL, params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', lang VARCHAR(2) DEFAULT NULL, INDEX IDX_23A0E6612469DE2 (category_id), UNIQUE INDEX UNIQ_23A0E664E7AF8F (gallery_id), INDEX IDX_23A0E66DE12AB56 (created_by), INDEX IDX_23A0E6625F94802 (modified_by), INDEX publish_idx (is_published), INDEX lang_idx (lang), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE blog__article_tags (article_id INT NOT NULL, tag_id INT NOT NULL, INDEX IDX_DFFE13277294869C (article_id), INDEX IDX_DFFE1327BAD26311 (tag_id), PRIMARY KEY(article_id, tag_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE blog__category (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, layout VARCHAR(60) NOT NULL, is_published SMALLINT NOT NULL, password VARCHAR(60) DEFAULT NULL, created DATETIME NOT NULL, lang VARCHAR(2) DEFAULT NULL, INDEX IDX_64C19C1727ACA70 (parent_id), INDEX publish_idx (is_published), INDEX lang_idx (lang), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE blog__article_hits (id INT AUTO_INCREMENT NOT NULL, article_id INT DEFAULT NULL, shows INT UNSIGNED NOT NULL, date DATE NOT NULL, INDEX IDX_AACDEB2A7294869C (article_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE blog__article_opened (article_id INT NOT NULL, user_id INT DEFAULT NULL, last_activity DATETIME NOT NULL, INDEX IDX_C791B0DBA76ED395 (user_id), PRIMARY KEY(article_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);

		$this->addSql(
			'ALTER TABLE blog__article ADD CONSTRAINT FK_23A0E6612469DE2 FOREIGN KEY (category_id) REFERENCES blog__category (id) ON DELETE SET NULL',
		);
		$this->addSql(
			'ALTER TABLE blog__article ADD CONSTRAINT FK_23A0E664E7AF8F FOREIGN KEY (gallery_id) REFERENCES gallery__album (id) ON DELETE SET NULL',
		);
		$this->addSql(
			'ALTER TABLE blog__article ADD CONSTRAINT FK_23A0E66DE12AB56 FOREIGN KEY (created_by) REFERENCES user (id) ON DELETE SET NULL',
		);
		$this->addSql(
			'ALTER TABLE blog__article ADD CONSTRAINT FK_23A0E6625F94802 FOREIGN KEY (modified_by) REFERENCES user (id) ON DELETE SET NULL',
		);
		$this->addSql(
			'ALTER TABLE blog__article_tags ADD CONSTRAINT FK_DFFE13277294869C FOREIGN KEY (article_id) REFERENCES blog__article (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__article_tags ADD CONSTRAINT FK_DFFE1327BAD26311 FOREIGN KEY (tag_id) REFERENCES tag (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__category ADD CONSTRAINT FK_64C19C1727ACA70 FOREIGN KEY (parent_id) REFERENCES blog__category (id) ON DELETE SET NULL',
		);
		$this->addSql(
			'ALTER TABLE blog__article_hits ADD CONSTRAINT FK_AACDEB2A7294869C FOREIGN KEY (article_id) REFERENCES blog__article (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__article_opened ADD CONSTRAINT FK_C791B0DB7294869C FOREIGN KEY (article_id) REFERENCES blog__article (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__article_opened ADD CONSTRAINT FK_C791B0DBA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)',
		);

		$this->addSql(
			'INSERT INTO blog__category (`id`, `parent_id`, `title`, `alias`, `layout`, `is_published`, `password`, `created`, `lang`) VALUES (\'1\', NULL, \'Nezařazené\', \'nezarazene\', \'default\', \'1\', NULL, \'2018-09-25 16:13:54\', NULL);',
		);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE blog__article_tags DROP FOREIGN KEY FK_DFFE13277294869C');
		$this->addSql('ALTER TABLE blog__article_hits DROP FOREIGN KEY FK_AACDEB2A7294869C');
		$this->addSql('ALTER TABLE blog__article_opened DROP FOREIGN KEY FK_C791B0DB7294869C');
		$this->addSql('ALTER TABLE blog__article DROP FOREIGN KEY FK_23A0E6612469DE2');
		$this->addSql('ALTER TABLE blog__category DROP FOREIGN KEY FK_64C19C1727ACA70');

		$this->addSql('DROP TABLE blog__article');
		$this->addSql('DROP TABLE blog__article_tags');
		$this->addSql('DROP TABLE blog__category');
		$this->addSql('DROP TABLE blog__article_hits');
		$this->addSql('DROP TABLE blog__article_opened');
	}
}
