<?php declare(strict_types = 1);

namespace Blog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200114175703 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE blog__article_in_category (id_article INT NOT NULL, id_category INT NOT NULL, INDEX IDX_1C037709DCA7A716 (id_article), INDEX IDX_1C0377095697F554 (id_category), PRIMARY KEY(id_article, id_category)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE blog__article_in_category ADD CONSTRAINT FK_1C037709DCA7A716 FOREIGN KEY (id_article) REFERENCES blog__article (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__article_in_category ADD CONSTRAINT FK_1C0377095697F554 FOREIGN KEY (id_category) REFERENCES blog__category (id) ON DELETE CASCADE',
		);
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		foreach ($this->connection->fetchAllAssociative("SELECT id, category_id FROM blog__article") as $row) {
			$this->connection->prepare(
				"INSERT IGNORE INTO blog__article_in_category (id_article, id_category) VALUES (?, ?)",
			)
				->execute([$row['id'], $row['category_id']]);
		}
	}

	public function down(Schema $schema): void
	{
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('DROP TABLE blog__article_in_category');
	}
}
