<?php declare(strict_types = 1);

namespace Blog\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210708125543 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE blog__favourite_article (id INT AUTO_INCREMENT NOT NULL, favourite_group VARCHAR(255) DEFAULT NULL, article INT DEFAULT NULL, user INT DEFAULT NULL, INDEX IDX_A2F0FEDFCCB5C5B0 (favourite_group), INDEX IDX_A2F0FEDF23A0E66 (article), INDEX IDX_A2F0FEDF8D93D649 (user), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE blog__favourite_group (ident VARCHAR(255) NOT NULL, image VARCHAR(255) DEFAULT NULL, PRIMARY KEY(ident)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE blog__favourite_group_text (lang VARCHAR(2) NOT NULL, ident VARCHAR(255) NOT NULL, title VARCHAR(255) DEFAULT NULL, alias VARCHAR(255) DEFAULT NULL, INDEX IDX_B753F39B44E78B2 (ident), INDEX favourite (ident, lang), PRIMARY KEY(ident, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE blog__favourite_article ADD CONSTRAINT FK_A2F0FEDFCCB5C5B0 FOREIGN KEY (favourite_group) REFERENCES blog__favourite_group (ident) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__favourite_article ADD CONSTRAINT FK_A2F0FEDF23A0E66 FOREIGN KEY (article) REFERENCES blog__article (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__favourite_article ADD CONSTRAINT FK_A2F0FEDF8D93D649 FOREIGN KEY (user) REFERENCES user (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE blog__favourite_group_text ADD CONSTRAINT FK_B753F39B44E78B2 FOREIGN KEY (ident) REFERENCES blog__favourite_group (ident) ON DELETE CASCADE',
		);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE blog__favourite_article DROP FOREIGN KEY FK_A2F0FEDFCCB5C5B0');
		$this->addSql('ALTER TABLE blog__favourite_group_text DROP FOREIGN KEY FK_B753F39B44E78B2');
		$this->addSql('DROP TABLE blog__favourite_article');
		$this->addSql('DROP TABLE blog__favourite_group');
		$this->addSql('DROP TABLE blog__favourite_group_text');
	}
}
