<?php declare(strict_types = 1);

namespace Blog\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class BlogCache
{
	final public const cacheNamespace = 'blog';

	protected Cache $cache;

	public function __construct(Storage $storage)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	public function getCache(): Cache { return $this->cache; }
}
