<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Blog\Model\BlogCache;
use Blog\Model\Categories;
use Doctrine;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\Http\Session;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CategoryListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static int $i = 0;
	protected Cache      $cache;
	protected Cache      $navigationCache;

	public function __construct(
		protected Storage   $cacheStorage,
		protected Session   $session,
		protected BlogCache $blogCache,
	)
	{
		$this->cache           = new Cache($cacheStorage, Categories::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(Category $category, PostPersistEventArgs|PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		foreach ($category->getTexts()->getKeys() as $l) {
			$this->cache->remove('categories/' . $l);
		}

		$this->navigationCache->clean([Cache::Tags => 'articles']);

		$this->blogCache->getCache()->clean([
			Cache::Tags => ['getAll', 'author', 'featured'],
		]);
	}
}
