<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Core\Model\Helpers\Traits\TExtraField;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'blog__favourite_group')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class FavouriteGroup
{
	use TTranslateListener;
	use TExtraField;

	public const EXTRA_FIELD_SECTION = 'blogFavourite';

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, nullable: false)]
	protected string $ident;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $image = null;

	/**
	 * @var Collection<string, FavouriteGroupText>
	 */
	#[ORM\OneToMany(mappedBy: 'ident', targetEntity: FavouriteGroupText::class, indexBy: 'lang')]
	protected Collection $texts;

	public function __construct(string $ident)
	{
		$this->ident       = $ident;
		$this->texts       = new ArrayCollection;
		$this->extraFields = new ArrayCollection;
	}

	public function getIdent(): string { return $this->ident; }

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?FavouriteGroupText
	{
		return $this->texts[$lang ?: $this->locale] ?? null;
	}

	/**
	 * @return Collection<string, FavouriteGroupText>
	 */
	public function getTexts() { return $this->texts; }
}
