<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'blog__favourite_group_text')]
#[ORM\Index(columns: ['ident', 'lang'], name: 'favourite')]
#[ORM\Entity]
class FavouriteGroupText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: FavouriteGroup::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'ident', referencedColumnName: 'ident', onDelete: 'CASCADE')]
	protected FavouriteGroup $favourite;

	#[ORM\Id]
	#[ORM\Column(name: 'lang', type: Types::STRING, length: 2, nullable: false)]
	protected string $lang;

	#[ORM\Column(name: 'title', type: Types::STRING, length: 255, nullable: true)]
	public ?string $title = null;

	#[ORM\Column(name: 'alias', type: Types::STRING, length: 255, nullable: true)]
	public ?string $alias = null;

	public function __construct(FavouriteGroup $favourite, string $lang)
	{
		$this->favourite = $favourite;
		$this->lang      = $lang;
	}

	public function getFavourite(): FavouriteGroup { return $this->favourite; }

	public function getLang(): string { return $this->lang; }
}
