<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

#[ORM\Table(name: 'blog__article_opened')]
#[ORM\Entity]
class Opened
{
	#[ORM\Id]
	#[ORM\OneToOne(targetEntity: Article::class)]
	#[ORM\JoinColumn(name: 'article_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Article $article;

	#[ORM\ManyToOne(targetEntity: User::class)]
	#[ORM\JoinColumn(name: 'user_id', referencedColumnName: 'id')]
	public ?User $user;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false)]
	public ?DateTimeInterface $lastActivity = null;

	public function __construct(Article $article, ?User $user)
	{
		$this->article      = $article;
		$this->user         = $user;
		$this->lastActivity = new DateTime;
	}
}
