<?php declare(strict_types = 1);

namespace Blog\Model\Rss;

use Nette;
use Nette\Http\IRequest;
use Nette\Http\IResponse;
use SimpleXMLElement;

/**
 * @property-read SimpleXMLElement $source
 */
class RssResponse implements Nette\Application\Response
{
	use Nette\SmartObject;

	public function __construct(protected readonly SimpleXMLElement $source)
	{
	}

	public function getSource(): SimpleXMLElement
	{
		return $this->source;
	}

	public function send(IRequest $httpRequest, IResponse $httpResponse): void
	{
		$httpResponse->setContentType('application/xml');
		echo $this->source->asXML();
	}
}
