<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Article\ArticleForm;
use Blog\AdminModule\Components\Article\IArticleFormFactory;
use Blog\Model\Entities\Article;
use Blog\Model\OpenedArticlesService;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\AbortException;
use Nette\Application\BadRequestException;
use Nette\Http\IResponse;

class ArticlesPresenter extends BasePresenter
{
	protected OpenedArticlesService $openedArticlesService;

	public function __construct(OpenedArticlesService $openedArticlesService)
	{
		parent::__construct();
		$this->openedArticlesService = $openedArticlesService;
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionAdd(): void
	{
		$this->setHeader('blog.title.newArticle', 'fa fa-list-alt');
	}

	/**
	 * @param int|string $id
	 * @throws BadRequestException
	 */
	public function actionEdit($id): void
	{
		$article = $this->em->getRepository(Article::class)->find($id);

		if (!$article) {
			$this->error();
		}

		$this->setHeader('blog.title.editArticle', 'fa fa-list-alt');
	}

	/**
	 * @param int|string $id
	 * @throws AbortException
	 */
	public function actionClose($id): void
	{
		$this->openedArticlesService->closeArticle($id);
		$this->redirect('Default:');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	protected function createComponentArticleForm(IArticleFormFactory $factory): ArticleForm
	{
		$control = $factory->create();
		if ($this->getParameter('id')) {
			$control->setArticle($this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('Articles:edit', $form->getCustomData('articleId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('Default:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('Default:default');
		};

		return $control;
	}
}
