<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Search;

use Blog\Model\Articles;
use Core\Model\UI\BaseControl;

class SearchControl extends BaseControl
{
	protected Articles $articlesService;

	public function __construct(Articles $articles)
	{
		$this->articlesService = $articles;
	}

	public function render(): void
	{
		$this->template->setFile(__DIR__ . '/default.latte');
		$this->template->render();
	}
}
