<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\ArticlesList;
use Blog\FrontModule\Components\IArticlesListFactory;
use Blog\FrontModule\Model\Categories;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Paths;

class DefaultPresenter extends BasePresenter
{
	/** @var Categories */
	protected Categories $categoriesService;

	/** @var TemplatePages @inject */
	public TemplatePages $templatePagesService;

	/** @var Paths @inject */
	public Paths $pathsService;

	public function __construct(Categories $categories)
	{
		parent::__construct();
		$this->categoriesService = $categories;
	}

	/*******************************************************************************************************************
	 * ==================================   Renders
	 */
	public function actionDefault(): void
	{
		$this['list']->setCategories($this->getActiveNavigation()->componentParams['categories'] ?? null);
		$this->template->categories = $this->categoriesService->getCategories($this->getActiveNavigation()->componentParams['categories']);

		$tpId = $this->getActiveNavigation()->componentParams['tpCategory'];
		if ($tpId) {
			$templatePage = $this->templatePagesService->get((int) $tpId);

			if ($templatePage) {
				$this->template->templateTextValues = $templatePage->getTexts();
				$this->template->setFile($this->pathsService->getTemplatePagesFile($templatePage->getTemplate()));
			}
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionSearch(): void
	{
		$word = $this->getParameter('word');
		if ($word) {
			$offset   = $this->getParameter('start', 0);
			$html     = '';
			$articles = $this->articlesService->searchFulltext($word, $offset);

			if ($articles) {
				foreach ($articles as $article) {
					$html .= '<li><a href="' . $this->link(':Blog:Front:Articles:detail', [$article['id']]) . '">' . $article['title'] . '</a></li>';
				}
				$this->payload->html = $html;
				$this->payload->more = count($articles) >= 20 ? '1' : '0';
			}

			$this->sendPayload();
		}

		if ($this->isAjax()) {
			$this->setLayout(APP_DIR . '/modules/@emptyLayout.latte');
			ob_start();
			$this->template->setFile(__DIR__ . '/templates/Default/search.latte');
			$this->getTemplate()->render();
			$this->payload->html = ob_get_clean();
			$this->sendPayload();
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentList(IArticlesListFactory $factory): ArticlesList
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$page = $control->getParameter('page');

			if ($page > 1) {
				$this['meta']->setMeta('robots', 'noindex,follow');
			}
		};

		return $control;
	}
}
