<?php declare(strict_types = 1);

namespace Blog\Model;

use Blog\Model\Entities\Article;
use Blog\Model\Entities\Hit;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\ORMException;
use Exception;
use Nette\Utils\DateTime;

/**
 * Použít pokud budou potřeba podrobnější statistiky
 *
 * @method Hit|null getReference($id)
 * @method Hit[] getAll()
 * @method Hit|null get($id)
 */
class ArticleHits extends BaseEntityService
{
	protected $entityClass = Hit::class;

	public function getCurrentByArticle(int $article): ?Hit
	{
		/** @var Article $article */
		$article = $this->em->getReference(Article::class, $article);
		$today   = new DateTime;

		/** @var Hit $stat */
		$stat = $this->getEr()->findOneBy(['article' => $article->getId(), 'date' => $today]);
		if (!$stat) {
			$stat = new Hit($article, $today);
			$this->em->persist($stat);
			$this->em->flush();
		}

		return $stat;
	}

	/**
	 * @param int|string $articleId
	 */
	public function addShow($articleId): void
	{
		try {
			$stat = $this->getCurrentByArticle((int) $articleId);
			$this->em->createQuery('UPDATE ' . Hit::class . ' h SET h.shows = h.shows + 1 WHERE h.id = :id')
				->setParameters([':id' => $stat->getId()])->execute();
		} catch (Exception $e) {
		}
	}

	/**
	 * @param int|string|int[]|string[] $ids
	 *
	 * @return int[]
	 */
	public function getSumByArticles($ids): array
	{
		$result = [];
		foreach ($this->getEr()->createQueryBuilder('h')
			         ->where(is_array($ids) ? 'h.article IN (:ids)' : 'h.article = :ids')->setParameter('ids', $ids)
			         ->getQuery()->getResult() as $row) {
			if (!isset($result[$row->article->getId()])) {
				$result[$row->article->getId()] = 0;
			}
			$result[$row->article->getId()] += $row->shows;
		}

		return $result;
	}

}
