<?php declare(strict_types = 1);

namespace Blog\Model;

use Core\Model\Helpers\BaseEntityService;
use Users\Model\Entities\User;

/**
 * @method User|null getReference($id)
 * @method User[] getAll()
 * @method User|null get($id)
 */
class Authors extends BaseEntityService
{
	protected $entityClass = User::class;

	public function findByAlias(string $alias): ?User
	{
		/** @var User|null $tmp */
		$tmp = $this->getEr()->findOneBy(['alias' => $alias]);

		return $tmp;
	}
}
