<?php declare(strict_types = 1);

namespace Blog\Model;

use Blog\Model\Entities\Category;
use Core\Model\Entities\Repository\NestedTreeRepository;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Doctrine\ORM\QueryBuilder;
use Exception;

/**
 * @method Category|null getReference($id)
 * @method Category[]|null getAll()
 * @method Category|null get($id)
 * @method NestedTreeRepository getEr()
 */
class Categories extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Category::class;

	public const CACHE_NAMESPACE = 'categories';

	public function getPublishedQuery(): QueryBuilder
	{
		return $this->getEr()->createQueryBuilder('c')->andWhere('c.isPublished = 1');
	}

	/**
	 * @return Category[]
	 */
	public function getPublished(): array
	{
		return $this->getPublishedQuery()->getQuery()->getResult();
	}

	/**
	 * @throws Exception
	 */
	public function removeCategory(int $id): bool
	{
		try {
			if ($category = $this->getEr()->find($id)) {
				$this->em->remove($category);
				$this->em->flush();

				return true;
			}
		} catch (Exception $e) {
		}

		return false;
	}

}
