<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="blog__category_text", indexes={@ORM\Index(name="category", columns={"category_id", "lang"})})
 * @ORM\Entity
 */
class CategoryText
{

	/**
	 * @var Category
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="texts")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $category;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	protected $lang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="alias", type="string", length=255)
	 */
	protected $alias;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default": 1})
	 */
	public $isPublished;

	/**
	 * @ORM\Column(name="`text`", type="text", nullable=true)
	 */
	public ?string $text = null;

	/**
	 * @ORM\Column(name="created", type="datetime")
	 */
	public ?\DateTimeInterface $created = null;

	public function __construct(
		Category $category,
		string   $title,
		string   $lang
	)
	{
		$this->category    = $category;
		$this->title       = $title;
		$this->lang        = $lang;
		$this->isPublished = 1;
		$this->created     = new DateTime;
	}

	public function getTitle(): ?string { return $this->title; }

	public function setTitle(string $title): self
	{
		$this->title = $title;
		if (!$this->alias) {
			$this->setAlias($title);
		}

		return $this;
	}

	public function getAlias(): ?string { return $this->alias ?: Strings::webalize($this->title); }

	public function setAlias(string $alias): self
	{
		$this->alias = Strings::webalize($alias);

		return $this;
	}
}
