<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Users\Model\Entities\User;

/**
 * @ORM\Table(name="blog__favourite_article")
 * @ORM\Entity
 */
class FavouriteArticle
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="FavouriteGroup")
	 * @ORM\JoinColumn(name="favourite_group", referencedColumnName="ident", onDelete="CASCADE")
	 */
	protected FavouriteGroup $group;

	/**
	 * @ORM\ManyToOne(targetEntity="Article")
	 * @ORM\JoinColumn(name="article", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Article $article;

	/**
	 * @ORM\ManyToOne(targetEntity="Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="user", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected User $user;

	public function __construct(FavouriteGroup $group, Article $article, User $user)
	{
		$this->group   = $group;
		$this->article = $article;
		$this->user    = $user;
	}

	public function getGroup(): FavouriteGroup { return $this->group; }

	public function getArticle(): Article { return $this->article; }

	public function getUser(): User { return $this->user; }
}
