<?php declare(strict_types = 1);

namespace Blog\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Search extends BaseNavigation implements INavigationItem
{
	protected $title     = 'search';
	protected $presenter = 'Blog:Front:Default';
	protected $action    = 'search';

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		return new BaseContainer;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action) {
			return 1;
		}

		return false;
	}

	/**
	 * @param DaoNavigationItem $params
	 * @param array             $urlParams
	 * @return array
	 */
	public function routerIn($params, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		if (isset($navigation->componentParams[$urlParams['action']]) && $navigation->componentParams[$urlParams['action']] == $urlParams['id']) {
			return $navigation->alias;
		}

		return null;
	}
}
