<?php declare(strict_types = 1);

namespace Blog\Model\Rss;

use Nette;
use Nette\Utils\DateTime;

class RssChannelItem
{
	use Nette\SmartObject;

	protected string $title;
	protected string $description;
	protected string $link;
	protected DateTime $pubDate;
	protected string $image;

	public function __construct(string $title, string $description, DateTime $pubDate, string $link, string $image)
	{
		$this->title       = $title;
		$this->description = $description;
		$this->link        = $link;
		$this->pubDate     = $pubDate;
		$this->image       = $image;
	}

	public function getTitle(): string
	{
		return $this->title;
	}

	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	public function getDescription(): string
	{
		return $this->description;
	}

	public function setDescription(string $description): void
	{
		$this->description = $description;
	}

	public function getLink(): string
	{
		return $this->link;
	}

	public function setLink(string $link): void
	{
		$this->link = $link;
	}

	public function getPubDate(): DateTime
	{
		return $this->pubDate;
	}

	public function setPubDate(DateTime $pubDate): void
	{
		$this->pubDate = $pubDate;
	}

	public function getImage(): string
	{
		return $this->image;
	}

	public function setImage(string $image): void
	{
		$this->image = $image;
	}
}