<?php declare(strict_types = 1);

namespace Blog\Model\Rss;

use Nette\Http\IRequest,
	Nette\Http\IResponse,
	Nette;
use SimpleXMLElement;

/**
 * @property-read SimpleXMLElement $source
 */
class RssResponse implements Nette\Application\Response
{
	use Nette\SmartObject;

	private SimpleXMLElement $source;

	public function __construct(SimpleXMLElement $source)
	{
		$this->source = $source;
	}

	public function getSource(): SimpleXMLElement
	{
		return $this->source;
	}

	public function send(IRequest $httpRequest, IResponse $httpResponse): void
	{
		$httpResponse->setContentType('application/xml');
		echo $this->source->asXML();
	}
}