<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Sites;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;
use Contributte\Translation\Translator;

class Articles extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'blogArticles';

	protected ArticlesService   $articlesService;
	protected CategoriesService $categoriesService;
	protected Translator        $translator;
	protected Sites             $sites;

	public function __construct(
		ArticlesService   $articles,
		CategoriesService $categories,
		Translator        $translator,
		Sites             $sites
	)
	{
		$this->articlesService   = $articles;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
		$this->sites             = $sites;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (count($this->sites->getSites()) > 1) {
			$formContainer->addCheckboxNestedList($this->getName(), $this->getTitle(), $this->categoriesService->getFlatTree());
		} else {
			$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $this->categoriesService->getOptionsForSelect());
		}
	}

	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		$limit = $params['limit'] ?? null;

		return $this->articlesService->getAll($this->getDefault(), null, $limit);
	}
}
