<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Search;

use Blog\Model\Articles;
use Core\Model\UI\BaseControl;

class SearchControl extends BaseControl
{

	/** @var Articles */
	protected $articlesService;

	public function __construct(Articles $articles)
	{
		$this->articlesService = $articles;
	}

	protected function attached($presenter)
	{
		parent::attached($presenter);
	}

	public function render()
	{
		$this->template->setFile(__DIR__ . '/default.latte');
		$this->template->render();
	}
}