<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model\Dao;

use Gallery\FrontModule\Model\Dao\Album;
use Nette\SmartObject;

class Article
{
	use SmartObject;

	/** @var int */
	public $id;

	/** @var string */
	public $lang;

	/** @var string */
	public $title;

	/** @var string */
	public $alias;

	/** @var string */
	public $introtext;

	/** @var string */
	public $fulltext;

	/** @var \DateTime */
	public $created;

	/** @var \DateTime */
	public $modified;

	public $createdBy;

	public $modifiedBy;

	/** @var int */
	public $categoryId;

	/** @var Category */
	public $category;

	public $tags;

	/** @var int */
	public $galleryId;

	/** @var Album */
	public $gallery;

	/** @var int */
	public $featured;

	/** @var array */
	public $params;

	public $publishUp;

	public $publishDown;

	public $link;

	public $seo;

	public function getId(): int { return $this->id; }

	public function getGallery(): ?Album { return $this->gallery; }

	public function getSeo(): ?array { return $this->seo; }

	public function getModified(): ?\DateTime { return $this->modified; }
}
