<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\IArticlesListFactory;
use Blog\Model\Articles;
use Blog\Model\Categories;

final class DefaultPresenter extends BasePresenter
{
	/** @var Categories */
	protected $categoriesService;

	/** @var Articles */
	protected $articlesService;

	public function __construct(Categories $categories, Articles $articles)
	{
		$this->categoriesService = $categories;
		$this->articlesService   = $articles;
	}

	/*******************************************************************************************************************
	 * ==================================   Renders
	 */
	public function actionDefault()
	{
		$this['list']->setCategories($this->getActiveNavigation()->componentParams['categories'] ?? null);
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionSearch()
	{
		$word = $this->getParameter('word');
		if ($word) {
			$offset   = $this->getParameter('start', 0);
			$html     = '';
			$articles = $this->articlesService->searchFulltext($word, $offset);

			if ($articles) {
				foreach ($articles as $article)
					$html .= '<li><a href="' . $this->link(':Blog:Front:Articles:detail', [$article['id']]) . '">' . $article['title'] . '</a></li>';
				$this->payload->html = $html;
				$this->payload->more = count($articles) >= 20 ? '1' : '0';
			}

			$this->sendPayload();
		}

		if ($this->isAjax()) {
			$this->setLayout(APP_DIR . '/modules/@emptyLayout.latte');
			ob_start();
			$this->template->setFile(__DIR__ . '/templates/Default/search.latte');
			$this->getTemplate()->render();
			$this->payload->html = ob_get_clean();
			$this->sendPayload();
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentList(IArticlesListFactory $factory)
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$page = $control->getParameter('page');

			if ($page > 1) {
				$this['meta']->setMeta('robots', 'noindex,follow');
			}
		};

		return $control;
	}
}