export class CeskaPosta {
	constructor(input) {
		self = this;
		this.currentFocus = 0;
		this.input = input;

		this.rawData = [];
		this.fetchingData = false;

		this.loadData();

		input.addEventListener("input", function (e) {
			let a, b, val = this.value;
			/*close any already open lists of autocompleted values*/
			self.closeAllLists();
			if (!val) {
				return false;
			}
			this.currentFocus = -1;

			let data = self.getData(val);

			if (data)
				this.parentNode.appendChild(data);
		});

		input.addEventListener("keydown", function (e) {
			let x = document.getElementById(this.id + "autocomplete-list");
			if (x) x = x.getElementsByTagName("div");
			if (e.keyCode == 40) {
				/*If the arrow DOWN key is pressed,
				increase the currentFocus letiable:*/
				this.currentFocus++;
				/*and and make the current item more visible:*/
				self.addActive(x);
			} else if (e.keyCode == 38) { //up
				/*If the arrow UP key is pressed,
				decrease the currentFocus letiable:*/
				this.currentFocus--;
				/*and and make the current item more visible:*/
				self.addActive(x);
			} else if (e.keyCode == 13) {
				/*If the ENTER key is pressed, prevent the form from being submitted,*/
				e.preventDefault();
				if (this.currentFocus > -1) {
					/*and simulate a click on the "active" item:*/
					if (x) x[this.currentFocus].click();
				}
			}
		});


		/*execute a function when someone clicks in the document:*/
		document.addEventListener("click", function (e) {
			self.closeAllLists(e.target);
		});
	}

	getData(term) {
		if (this.rawData == null)
			this.loadData();

		if (term.length <= 2)
			return;

		term = term.toLowerCase();
		console.log(term);

		let a = document.createElement("DIV");
		a.setAttribute("id", this.input.id + "autocomplete-list");
		a.setAttribute("class", "autocomplete-items");

		for (let i in this.rawData) {
			let row = this.rawData[i];

			if (row.innerHTML.toLowerCase().indexOf(term) !== -1)
				a.appendChild(row);
		}

		return a;
	}

	loadData() {
		if (this.fetchingData == false) {
			this.fetchingData = true;
			self = this;

			let xhttp = new XMLHttpRequest();
			xhttp.onreadystatechange = function () {
				if (this.readyState == 4 && this.status == 200) {
					self.rawData = [];
					let data = this.responseText;
					let b = document.createElement("DIV");
					let obj = JSON.parse(data);
					for (let x in obj) {
						/*create a DIV element for each matching element:*/
						b = document.createElement("DIV");
						/*make the matching letters bold:*/
						b.innerHTML = "<p title='" + obj[x].openingHours + "'>" + obj[x].psc + ", " + obj[x].name + ", " + obj[x].village + ", " + obj[x].partVillage + "</p>";
						/*insert a input field that will hold the current array item's value:*/
						b.innerHTML += "<input type='hidden' value='" + obj[x].psc + ", " + obj[x].name + ", " + obj[x].village + ", " + obj[x].partVillage + "'>";
						/*execute a function when someone clicks on the item value (DIV element):*/
						b.addEventListener("click", function (e) {
							/*insert the value for the autocomplete text field:*/
							self.input.value = this.getElementsByTagName("input")[0].value;
							let term = this.getElementsByTagName("input")[0].value.split(', ');
							document.getElementById('postOfficePsc').value = term[0];
							/*close the list of autocompleted values,
							(or any other open lists of autocompleted values:*/
							self.closeAllLists();
						});

						self.rawData.push(b);
					}
				}
			};
			xhttp.open("GET", "/cron/ceskaposta/default/postofficeautocomplete", true);
			xhttp.send();
		}
	}

	/*execute a function when someone writes in the text field:*/

	/*execute a function presses a key on the keyboard:*/


	addActive(x) {
		/*a function to classify an item as "active":*/
		if (!x) return false;
		/*start by removing the "active" class on all items:*/
		self.removeActive(x);
		if (this.currentFocus >= x.length) this.currentFocus = 0;
		if (this.currentFocus < 0) this.currentFocus = (x.length - 1);
		/*add class "autocomplete-active":*/
		x[this.currentFocus].classList.add("autocomplete-active");
	}

	removeActive(x) {
		/*a function to remove the "active" class from all autocomplete items:*/
		for (let i = 0; i < x.length; i++) {
			x[i].classList.remove("autocomplete-active");
		}
	}

	closeAllLists(elmnt) {
		/*close all autocomplete lists in the document,
		except the one passed as an argument:*/
		let x = document.getElementsByClassName("autocomplete-items");
		for (let i = 0; i < x.length; i++) {
			if (elmnt != x[i] && elmnt != this.input) {
				x[i].parentNode.removeChild(x[i]);
			}
		}
	}
}
