<?php declare(strict_types = 1);

namespace Ceskaposta\CronModule\Presenters;

use Ceskaposta\Model\PostOffices;

/**
 * Class DefaultPresenter
 * @package Import\CronModule\Presenters
 */
class DefaultPresenter extends BasePresenter
{

	/** @var PostOffices @inject */
	public $postOfficeService;

	public function actionUpdatePostOffice($id)
	{

		$data = $this->postOfficeService->updatePostOffices();

		$this->sendJson($data);
	}

	public function actionPostOfficeAutocomplete($term)
	{
		$term = $this->getParameter('term', null);

		$postOffices = $this->postOfficeService->getPostOffices($term);
		$output      = [];
		foreach ($postOffices as $postOffice) {
			$output[$postOffice->psc] = [
				'psc'          => $postOffice->psc,
				'name'         => $postOffice->namePostOffice,
				'village'      => $postOffice->village,
				'partVillage'  => $postOffice->partVillage,
				'openingHours' => $postOffice->openingHours,
			];
		}

		$this->getPresenter()->sendJson($output);
	}

}
