<?php declare(strict_types = 1);


namespace Ceskaposta\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="ceskaposta__post_offices")
 * @ORM\Entity
 */
class PostOffice
{
	/**
	 * @ORM\Id
	 * @ORM\Column(name="psc", type="string", length=5)
	 * @var string
	 */
	public $psc;

	/**
	 * @ORM\Column(name="naz_prov", type="string", length=50)
	 * @var string
	 */
	public $namePostOffice;

	/**
	 * @ORM\Column(name="okres", type="string", length=40)
	 * @var string
	 */
	public $nameDistrict;

	/**
	 * @ORM\Column(name="adresa", type="string")
	 * @var string
	 */
	public $address;

	/**
	 * @ORM\Column(name="v_provozu", type="string", length=1)
	 * @var string
	 */
	public $isActive;

	/**
	 * @ORM\Column(name="prodl_doba", type="string", length=1)
	 * @var string
	 */
	public $extendedTime;

	/**
	 * @ORM\Column(name="bankomat", type="string", length=1)
	 * @var string
	 */
	public $atm;

	/**
	 * @ORM\Column(name="parkoviste", type="string", length=1)
	 * @var string
	 */
	public $parking;

	/**
	 * @ORM\Column(name="komplet_servis", type="string", length=1)
	 * @var string
	 */
	public $completeService;

	/**
	 * @ORM\Column(name="vikend", type="string", length=1)
	 * @var string
	 */
	public $weekend;

	/**
	 * @ORM\Column(name="lokality_prodl", type="string", length=1)
	 * @var string
	 */
	public $districtExtendedTime;

	/**
	 * @ORM\Column(name="vydej_np_od", type="string", length=5, nullable = true)
	 * @var string
	 */
	public $vydejNpOd;

	/**
	 * @ORM\Column(name="ukl_np_limit", type="string", length=1)
	 * @var string
	 */
	public $uklNpLimit;

	/**
	 * @ORM\Column(name="psc_np_nahr", type="string", length=5, nullable = true)
	 * @var string
	 */
	public $pscNpNahr;

	/**
	 * @ORM\Column(name="naz_np_nahr", type="string", length=50)
	 * @var string
	 */
	public $nazNpNahr;

	/**
	 * @ORM\Column(name="abc_box", type="string", length=1, nullable = true)
	 * @var string
	 */
	public $abcBox;

	/**
	 * @ORM\Column(name="otv_doba", type="text")
	 * @var string
	 */
	public $openingHours;

	/**
	 * @ORM\Column(name="obec", type="string", length=50)
	 * @var string
	 */
	public $village;

	/**
	 * @ORM\Column(name="c_obce", type="string", length=50, nullable = true)
	 * @var string
	 */
	public $partVillage;

	public function getStreet(): string
	{
		return trim(explode($this->psc, $this->address, 2)[0] ?? $this->partVillage, " \t\n\r\0\x0B,");
	}
}
