<?php declare(strict_types = 1);

namespace Ceskaposta\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use EshopOrders\Model\Entities\Order;

/**
 * @ORM\Table(name="ceskaposta__post_office_order")
 * @ORM\Entity
 */
class PostOfficeOrder
{
	use MagicAccessors;

	/**
	 * @var Order
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $order;

	/**
	 * @var string
	 * @ORM\Column(name="post_psc", type="string")
	 */
	protected $postPSC;

	/**
	 * @var string
	 * @ORM\Column(name="post_name", type="string")
	 */
	public $postName;

	/**
	 * @var string
	 * @ORM\Column(name="village", type="string")
	 */
	public $village;

	/**
	 * @var string
	 * @ORM\Column(name="part_village", type="string")
	 */
	public $partVillage;

	public function __construct(Order $order, string $postPSC)
	{
		$this->order    = $order;
		$this->postPSC = $postPSC;
	}

	public function getOrder(): Order { return $this->order; }

	public function getPostPSC(): string { return $this->postPSC; }

}
