<?php declare(strict_types = 1);

namespace Ceskaposta\Model;

use Ceskaposta\Model\Entities\PostOffice;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\Common\Collections\ArrayCollection;

class PostOffices extends BaseEntityService
{

	protected $entityClass = PostOffice::class;

	/**
	 * @param $term
	 *
	 * @return mixed
	 */
	public function getPostOffices($term = null)
	{
		$q = $this->em->getRepository($this->entityClass)->createQueryBuilder('po');

		if ($term) {
			$q->where('po.psc like :term')->orWhere('po.village like :term')->orWhere('po.partVillage like :term')
				->setParameter('term', '%' . $term . '%');
		}

		return $q->getQuery()->getResult();
	}

	/**
	 * @return Exception|\Exception|string
	 * @throws \Exception
	 */
	public function updatePostOffices()
	{
		try {
			$xml = simplexml_load_file('http://napostu.cpost.cz/vystupy/napostu_1.xml', null, LIBXML_NOCDATA);
			if (!$xml) {
				throw new Exception('Nepodařil se stáhnout soubor ze serveru České pošty.');
			}

			$json = json_encode($xml);
			$list = json_decode($json, true);

			//Odstraneni vsech zaznamů;
			$this->em->createQuery('DELETE FROM ' . $this->entityClass)->execute();

			$batchSize = 20;
			$i         = 1;

			foreach ($list['row'] as $item) {
				if (is_array($item)) {
					$postOffice                       = new PostOffice();
					$postOffice->psc                  = $item['PSC'];
					$postOffice->namePostOffice       = $item['NAZ_PROV'];
					$postOffice->nameDistrict         = $item['OKRES'];
					$postOffice->address              = $item['ADRESA'];
					$postOffice->isActive             = $item['V_PROVOZU'];
					$postOffice->extendedTime         = $item['PRODL_DOBA'];
					$postOffice->atm                  = $item['BANKOMAT'];
					$postOffice->parking              = $item['PARKOVISTE'];
					$postOffice->completeService      = $item['KOMPLET_SERVIS'];
					$postOffice->weekend              = $item['VIKEND'];
					$postOffice->districtExtendedTime = $item['LOKALITY_PRODL'];
					$postOffice->vydejNpOd            = $this->prazdnyRet($item['VYDEJ_NP_OD']);
					$postOffice->uklNpLimit           = $item['UKL_NP_LIMIT'];
					$postOffice->pscNpNahr            = $this->prazdnyRet($item['PSC_NP_NAHR']);
					$postOffice->nazNpNahr            = $this->prazdnyRet($item['NAZ_NP_NAHR']);
					$postOffice->abcBox               = $item['ABC_BOX'];
					$postOffice->openingHours         = $this->retDnu($item['OTV_DOBA']);
					$postOffice->village              = $item['OBEC'];
					$postOffice->partVillage          = $this->prazdnyRet($item['C_OBCE']);

					$this->em->persist($postOffice);
					if (($i % $batchSize) === 0) {
						$this->em->flush();
						$this->em->clear(); // Detaches all objects from Doctrine!
					}
					$i++;
				}
			}
			$this->em->flush(); //Persist objects that did not make up an entire batch
			$this->em->clear();
		} catch (Exception $e) {
			return $e;
		}

		return 'OK';
	}

	private function retDnu(array $polednu)
	{
		$ret = '';
		foreach ($polednu as $dny) {
			foreach ($dny as $den) {
				$ret .= $den["@attributes"]["name"] . ': ';
				if (key_exists("od_do", $den)) {
					if (key_exists("od", $den["od_do"])) {
						$ret .= $den["od_do"]["od"] . ' - ' . $den["od_do"]["do"];
					} else {
						foreach ($den["od_do"] as $op) {
							$ret .= $op["od"] . ' - ' . $op["do"] . ', ';
						}
						$ret = substr($ret, 0, strlen($ret) - 2);
					}
				}
				$ret .= '|';
			}
		}

		return $ret;
	}

	private function prazdnyRet($value)
	{
		if (!empty($value))
			return ($value);

		return '-';
	}

}
