document.addEventListener('click', e => {
	const target = e.target;

	if (target.dataset.cpostPickupTrigger !== undefined) {
		const popup = document.createElement('div');
		popup.setAttribute('data-input', target.id);
		popup.setAttribute('data-data', target.dataset.data);
		popup.setAttribute('id', 'cpostIframePopup');
		popup.setAttribute('style', 'z-index: 999999; position: fixed; -webkit-backface-visibility: hidden; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.3);');

		const wrap = document.createElement('div');
		wrap.setAttribute('style', 'position: absolute; left: 0px; top: 0px; width: 100%; height: 100svh; padding: 1rem .7rem; display: flex; flex-direction: column;');

		const head = document.createElement('div');
		head.setAttribute('style', 'text-align: right; padding: 1rem; height: 4rem');
		head.classList.add('primary-bg-color');

		const close = document.createElement('a');
		close.setAttribute('href', 'javascript:;');
		close.setAttribute('style', 'cursor: pointer; display: inline-block;');
		close.innerHTML = '<i style="fill: #fff; width: 2rem; height: 2rem;" data-svg-icon-pshk="close"></i>';
		close.addEventListener('click', e => {
			popup.remove();
		});

		head.appendChild(close);
		wrap.appendChild(head);

		const iframe = document.createElement('iframe');

		const url = new URL('https://b2c.cpost.cz/locations/');
		url.searchParams.set('skipLocation', 'false');
		url.searchParams.set('type', 'BALIKOVNY');

		if (target.dataset.cpostDisableBox && target.dataset.cpostDisableBox === '1') {
			url.searchParams.set('disableBoxes', 'true');
		}

		iframe.setAttribute('style', 'background: white; border: hidden; width: 100%; flex: 1;');
		iframe.setAttribute('src', url.toString());
		iframe.setAttribute('allow', 'geolocation');
		wrap.appendChild(iframe);

		popup.appendChild(wrap);

		document.body.appendChild(popup);

		document.dispatchEvent(new Event('loadSvgIcons'));
	}
});

function iframeListener(event) {
	if (event.data.message === 'pickerResult') {
		const ps = event.data.point;

		if (ps === undefined) {
			return;
		}

		const iframePopup = document.getElementById('cpostIframePopup');
		if (!iframePopup)
			return;

		let data = {
			id     : ps.id,
			address: ps.address,
			name   : ps.name
		};

		const dataEl = document.getElementById(iframePopup.dataset.data);
		if (dataEl) {
			dataEl.value = JSON.stringify(data);
		}

		const inputPlaceholder = document.getElementById(iframePopup.dataset.input);
		inputPlaceholder.value = ps.name + ' - ' + ps.address + ' ' + ps['municipality_name'];
		const inputTarget      = document.getElementById(inputPlaceholder.dataset.cpostPickupTrigger);
		inputTarget.value      = ps.zip;

		let e = new CustomEvent('pickup-changed', {
			detail: {
				expedition: 'ceskaposta'
			}
		});

		window.dispatchEvent(e);

		iframePopup.remove();
	}
}

window.addEventListener('message', iframeListener);
