<?php declare(strict_types=1);

namespace Ceskaposta\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ceskaposta__parcel_number_delivery_to_hand")
 * @ORM\Entity
 */
class ParcelNumberDeliveryToHand implements ICeskaPostaNumberPackage
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $numberPackage;

	/**
	 * @ORM\ManyToOne(targetEntity="ParcelDeliveryToHandOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="parcel_order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	public ParcelDeliveryToHandOrder $parcelOrder;

	public function __construct(string $numberPackage, ParcelDeliveryToHandOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}

}