<?php declare(strict_types=1);

namespace Ceskaposta\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ceskaposta__parcel_number_post_office")
 * @ORM\Entity
 */
class ParcelNumberPostOffice implements ICeskaPostaNumberPackage
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $numberPackage;

	/**
	 * @ORM\ManyToOne(targetEntity="PostOfficeOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="parcel_order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	protected PostOfficeOrder $parcelOrder;

	public function __construct(string $numberPackage, PostOfficeOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}

}