<?php declare(strict_types=1);

namespace Ceskaposta\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ceskaposta__parcel_number_post_warehouse")
 * @ORM\Entity
 */
class ParcelNumberPostWarehouse implements ICeskaPostaNumberPackage
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $numberPackage;

	/**
	 * @ORM\ManyToOne(targetEntity="PostWarehouseOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="parcel_order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	public PostWarehouseOrder $parcelOrder;

	public function __construct(string $numberPackage, PostWarehouseOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}
}