<?php declare(strict_types=1);

namespace Ceskaposta\Model;

use Ceskaposta\Model\Entities\ParcelDeliveryToHandOrder;
use Ceskaposta\Model\Entities\ParcelNumberDeliveryToHand;
use Ceskaposta\Model\Entities\ParcelNumberPostOffice;
use Ceskaposta\Model\Entities\ParcelNumberPostWarehouse;
use Ceskaposta\Model\Entities\PostOfficeOrder;
use Ceskaposta\Model\Entities\PostWarehouseOrder;

class Helper
{
	/**
	 * @return string[]
	 */
	public static function getClassesByParcelCode(string $code): array
	{
		$prefix = substr($code, 0, 2);
		$classes = [
			ParcelDeliveryToHandOrder::PREFIX_PARCEL_CODE => [ParcelDeliveryToHandOrder::class],
			PostOfficeOrder::PREFIX_PARCEL_CODE => [PostOfficeOrder::class],
			PostWarehouseOrder::PREFIX_PARCEL_CODE => [PostWarehouseOrder::class, PostOfficeOrder::class],
		];

		return $classes[$prefix] ?? $classes[ParcelDeliveryToHandOrder::PREFIX_PARCEL_CODE];
	}

	public static function getAssociatedClassByMainClass(string $class): string
	{
		switch ($class) {
			case PostWarehouseOrder::class:
				return ParcelNumberPostWarehouse::class;
			case PostOfficeOrder::class:
				return ParcelNumberPostOffice::class;
			case ParcelDeliveryToHandOrder::class:
			default:
				return ParcelNumberDeliveryToHand::class;
		}
	}
}