<?php declare(strict_types=1);

namespace Ceskaposta\Model;

class OrderExpeditionHelper
{
	public static function getPackageSizes(): array
	{
		return [
			null => 'ceskaposta.expeditionForm.choose',
			'm' => 'M',
			's' => 'S',
			'l' => 'L',
			'xl' => 'XL'
		];
	}

	public static function getVariableSymbols(): array
	{
		return [
			AdvancedOptions::VARIABLE_SYMBOL_AS_ORDER_NUMBER   => 'ceskaposta.expeditionForm.variableSymbol.options.orderNumber',
			AdvancedOptions::VARIABLE_SYMBOL_AS_INVOICE_NUMBER => 'ceskaposta.expeditionForm.variableSymbol.options.invoiceNumber'
		];
	}

	public static function getServices(): array
	{
		$arr = [
			'45' => null,
			'41' => null,
			'2'  => null,
			'4'  => null,
			'5'  => null,
			'40' => null,
			'3'  => null,
			'1'  => null,
			'77' => null,
			'78' => null,
			'76' => null,
			'46' => null,
			'11' => null,
			'26' => null,
			'16' => null,
			'10' => null,
			'20' => null,
			'6'  => null,
			'30' => null,
			'28' => null,
			'97' => null,
			'34' => null,
			'7'  => null,
			'21' => null,
			'8'  => null,
			'1K' => null
		];
		foreach ($arr as $k => $v) {
			$arr[$k] = 'ceskaposta.cpServices.' . $k;
		}

		return $arr;
	}

}